/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Meltdown {
    private static final int DURATION = 100;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final double magnitude;
    private final double chance;
    private final UUID multiblockID;
    private int ticksExisted;

    public Meltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, UUID multiblockID) {
        this(minPos, maxPos, magnitude, chance, multiblockID, 0);
    }

    private Meltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, UUID multiblockID, int ticksExisted) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.magnitude = magnitude;
        this.chance = chance;
        this.multiblockID = multiblockID;
        this.ticksExisted = ticksExisted;
    }

    public static Meltdown load(CompoundTag tag) {
        return new Meltdown(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("min")), NbtUtils.m_129239_((CompoundTag)tag.m_128469_("max")), tag.m_128459_("magnitude"), tag.m_128459_("chance"), tag.m_128342_("inventoryID"), tag.m_128451_("age"));
    }

    public void write(CompoundTag tag) {
        tag.m_128365_("min", (Tag)NbtUtils.m_129224_((BlockPos)this.minPos));
        tag.m_128365_("max", (Tag)NbtUtils.m_129224_((BlockPos)this.maxPos));
        tag.m_128347_("magnitude", this.magnitude);
        tag.m_128347_("chance", this.chance);
        tag.m_128362_("inventoryID", this.multiblockID);
        tag.m_128405_("age", this.ticksExisted);
    }

    public boolean update(Level world) {
        ++this.ticksExisted;
        if (world.f_46441_.nextInt() % 10 == 0 && world.f_46441_.nextDouble() < this.magnitude * this.chance) {
            int x = Mth.m_14072_((Random)world.f_46441_, (int)this.minPos.m_123341_(), (int)this.maxPos.m_123341_());
            int y = Mth.m_14072_((Random)world.f_46441_, (int)this.minPos.m_123342_(), (int)this.maxPos.m_123342_());
            int z = Mth.m_14072_((Random)world.f_46441_, (int)this.minPos.m_123343_(), (int)this.maxPos.m_123343_());
            this.createExplosion(world, x, y, z, 8.0f, true, Explosion.BlockInteraction.DESTROY);
        }
        if (!WorldUtils.isBlockLoaded((BlockGetter)world, this.minPos) || !WorldUtils.isBlockLoaded((BlockGetter)world, this.maxPos)) {
            return true;
        }
        return this.ticksExisted >= 100;
    }

    private void createExplosion(Level world, double x, double y, double z, float radius, boolean causesFire, Explosion.BlockInteraction mode) {
        MeltdownExplosion explosion = new MeltdownExplosion(world, x, y, z, radius, causesFire, mode, this.multiblockID);
        ArrayList<BlockPos> toBlow = new ArrayList<BlockPos>();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (double)j / 7.5 - 1.0;
                    double d1 = (double)k / 7.5 - 1.0;
                    double d2 = (double)l / 7.5 - 1.0;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = x;
                    double d6 = y;
                    double d8 = z;
                    for (float f = radius * (0.7f + world.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = world.m_8055_(pos);
                        FluidState fluidstate = blockstate.m_60819_();
                        if (!blockstate.m_60795_() || !fluidstate.m_76178_()) {
                            f -= (Math.max(blockstate.getExplosionResistance((BlockGetter)world, pos, (Explosion)explosion), fluidstate.getExplosionResistance((BlockGetter)world, pos, (Explosion)explosion)) + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (double)this.minPos.m_123341_() <= d4 && (double)this.minPos.m_123342_() <= d6 && (double)this.minPos.m_123343_() <= d8 && d4 <= (double)this.maxPos.m_123341_() && d6 <= (double)this.maxPos.m_123342_() && d8 <= (double)this.maxPos.m_123343_()) {
                            toBlow.add(pos);
                        }
                        d4 += d0 * 0.3;
                        d6 += d1 * 0.3;
                        d8 += d2 * 0.3;
                    }
                }
            }
        }
        if (!ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            explosion.m_46061_();
            explosion.m_46075_(true);
        }
        Collections.shuffle(toBlow, world.f_46441_);
        ArrayList drops = new ArrayList();
        for (BlockPos toExplode : toBlow) {
            BlockState state = world.m_8055_(toExplode);
            if (state.m_60795_()) continue;
            if (state.canDropFromExplosion((BlockGetter)world, toExplode, (Explosion)explosion) && world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                BlockEntity tileentity = state.m_155947_() ? world.m_7702_(toExplode) : null;
                LootContext.Builder lootContextBuilder = new LootContext.Builder(level).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)toExplode)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity).m_78984_(LootContextParams.f_81455_, null);
                if (mode == Explosion.BlockInteraction.DESTROY) {
                    lootContextBuilder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(radius));
                }
                state.m_60724_(lootContextBuilder).forEach(stack -> Meltdown.addBlockDrops(drops, stack, toExplode));
            }
            state.onBlockExploded(world, toExplode, (Explosion)explosion);
        }
        for (Pair pair : drops) {
            Block.m_49840_((Level)world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void addBlockDrops(List<Pair<ItemStack, BlockPos>> dropPositions, ItemStack stack, BlockPos pos) {
        int size = dropPositions.size();
        for (int i = 0; i < size; ++i) {
            Pair<ItemStack, BlockPos> pair = dropPositions.get(i);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositions.set(i, (Pair<ItemStack, BlockPos>)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        dropPositions.add((Pair<ItemStack, BlockPos>)Pair.of((Object)stack, (Object)pos));
    }

    public static class MeltdownExplosion
    extends Explosion {
        private final UUID multiblockID;

        private MeltdownExplosion(Level world, double x, double y, double z, float radius, boolean causesFire, Explosion.BlockInteraction mode, UUID multiblockID) {
            super(world, null, null, null, x, y, z, radius, causesFire, mode);
            this.multiblockID = multiblockID;
        }

        public UUID getMultiblockID() {
            return this.multiblockID;
        }
    }
}

